#ifndef __CHostCanDo__
#define __CHostCanDo__

#include <Basics/CString.hpp>
#include <audioeffectx.h>
using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace Vst
	{
		/**
		 * @class CHostCanDo CHostCanDo.hpp
		 * @brief Stores information about what a host can do
		 *
		 * @date 15/02/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.0.1 Converted to class, and split across files
		 * @version 1.0.2 Made virtual functions non virtual.
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 * Please note that VST is copyright Steinberg Media GmBh. No challenge is made to any of their trademarks
		 * To use this file, you require a copy of the VST SDK, available from www.steinberg.net for free
		 *
		 * $Id: CHostCanDo.hpp,v 1.3 2007/02/08 21:08:23 paul Exp $
		 */
		class CHostCanDo
		{
		public:

			/**
			 * Construction (sets all values, assuming theEffect is valid)
			 * @param theEffect The effect to setup and store
			 */
			CHostCanDo(AudioEffectX *theEffect);

			/**
			 * Construction (just initialises)
			 */
			CHostCanDo();

			/**
			 * Destruction
			 */
			virtual ~CHostCanDo();

//	===========================================================================

			/**
			 * Initialise the object
			 */
			void initialise();

			/**
			 * Set from audio effect
			 * @param theEffect The effect to setup and store
			 */
			void setFromAudioEffectX(AudioEffectX *theEffect);

//	===========================================================================

			/**
			 * @note Okay so these public variables are technically breaking the\n
			 * Exponent coding rules! But hell, do we really need a gazilion\n
			 * accessor functions?\n
			 * If i do just one function where you have to pass in flags\n
			 * you may as well just use the default vst version
			 */

//	===========================================================================

			bool m_sendVstEvents;					/**< Can send vst events */
			bool m_sendVstMidiEvent;				/**< can send vst midi event */
			bool m_sendVstTimeInfo;					/**< can send vst time info */
			bool m_recieveVstEvents;				/**< can recieve vst events */
			bool m_receiveVstMidiEvent;				/**< can recieve vst midi evnet */
			bool m_receiveVstTimeInfo;				/**< can recieve vst time info */
			bool m_reportConnectionChanges;			/**< can report connection changes */
			bool m_acceptIOChanges;					/**< allows changes to the io setup */
			bool m_sizeWindow;						/**< can resize the editor window */
			bool m_asyncProcessing;					/**< an process asynchronously (??) */
			bool m_offline;							/**< can process offline */
			bool m_supplyIdle;						/**< can supply idle (I thought all hosts could do this..) */
			bool m_supportShell;					/**< supports shell plugins */
			bool m_editFile;						/**< ? */
			bool m_closeFileSelector;				/**< Close any open file selectors */
			bool m_startStopProcess;				/**< ? */
			CString m_hostName;						/**< Name of the host */
			CString m_hostDeveloper;				/**< Name of the developer */
			long m_hostVersion;						/**< Version of the host */

		};
	}
}
#endif	// End of CHostCanDo.hpp